import java.net.*;
import java.io.*;
import java.awt.*;
import java.util.Vector;
import java.util.StringTokenizer;
import symantec.itools.lang.Context;
import JMapTag;
import JMapRectangle;
import JTokenParser;

class JMapTagsContentHandler extends java.net.ContentHandler
{
    private String strBuffer_ = "";
    private int iBufPos = 0;
    private int iLength = 0;
    private int iImage = 1;
    private MediaTracker mediaTracker = new MediaTracker(Context.getApplet());
    protected Vector vecTagObjects_ = new Vector();
    protected Vector vecLevels_ = new Vector();
    private JMapRectangle recInitialMap_;
    
    public JMapRectangle getInitialMap(){
        return new JMapRectangle(recInitialMap_);
    }
    public Object getContent(URLConnection urlc){
	    byte bBuffer[];
	    try{
            InputStream is = urlc.getInputStream();
            DataInputStream ds = new DataInputStream(is);
            iLength = urlc.getContentLength();
            if(iLength != -1){
                bBuffer = new byte[iLength];
                ds.readFully(bBuffer);
                strBuffer_ = new String(bBuffer,0);
            }
            else{
                int i = is.read();
                while(i != -1){
                       strBuffer_ = strBuffer_+(char)i;
                       i = is.read();
                }
            }
            return parseDataBuffer();
    	}
	    catch (IOException e) {}
        return null;
    }

	private protected Object parseDataBuffer(){
        String strToken = new String("");
        StringTokenizer st = new StringTokenizer(strBuffer_," \t\n\r");
        
        while (st.hasMoreTokens()) {
            strToken = st.nextToken(" \t\n\r");
            if(strToken.equalsIgnoreCase("TAG") && st.hasMoreTokens()){
                vecTagObjects_.addElement(parseTAG(st));
            }
            else if(strToken.equalsIgnoreCase("DISPLAYLEVEL") && st.hasMoreTokens()){
                parseDISPLAYLEVEL(st);
            }
            else if(strToken.equalsIgnoreCase("INITIALMAP") && st.hasMoreTokens()){
                parseINITALMAP(st);
            }
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException e) {}
   	    return vecTagObjects_;

    }
      private protected JMapTag parseTAG(StringTokenizer sts){
        String lineToken = "", strObjType;
        Integer red, green, blue;
        
        strObjType = JTokenParser.parseQuoteString(sts);
        JMapTag tag = new JMapTag(strObjType);
        
        lineToken = sts.nextToken();
        while(sts.hasMoreTokens() && !lineToken.equalsIgnoreCase("END")){
            if(lineToken.equalsIgnoreCase("DL")){
                tag.addLevels(JTokenParser.parseIntegerVec(sts));
            }
            else if(lineToken.equalsIgnoreCase("COLOR")){
                tag.setColor(JTokenParser.parseIntegerVec(sts));
            }
            else if(lineToken.equalsIgnoreCase("IMAGE")){
                lineToken = JTokenParser.parseQuoteString(sts);
                try{
                    Image im = Context.getApplet().getImage(new java.net.URL(Context.getApplet().getCodeBase(),lineToken));
                    mediaTracker.addImage(im,iImage++);
                    tag.setImage(im);
                }
                catch (MalformedURLException e) {}
            }
            else if(lineToken.equalsIgnoreCase("SUBTYPE")){
                lineToken = sts.nextToken();
            }

            lineToken = sts.nextToken();
        }
        return tag;
	}
	
    private protected void parseDISPLAYLEVEL(StringTokenizer sts){
        String lineToken = sts.nextToken();
        Vector v = JTokenParser.parseIntegerVec(sts);
        Vector dl = new Vector();
        dl.addElement(lineToken);
    }
    
    private protected void parseINITALMAP(StringTokenizer sts){
        recInitialMap_ = new JMapRectangle(JTokenParser.parseDoubleVec(sts));
    }
}

