import JMapPoint;
import java.awt.*;
import java.util.*;

class JMapTransformBase 
{
    protected Rectangle screen_;                   // screen space rectangle
    protected double scale_;                       // default scale factor  (screen width)/(map width)
	protected double centerMap_, centerScreen_;    // map center coordinate (lon) and the screen center (x)
	protected double latScale_;                    // x scale factor.. based on y with Mercator
    protected double ox_, oy_;                     // upper left hand coordinates of the map taken from _mpc
	protected double x1_, x2_, y1_, y2_;           // map coordinates

	JMapTransformBase(Rectangle screen, double x1, double y1, double x2, double y2){
	    x1_ = x1;
	    x2_ = x2;
	    y1_ = y1;
	    y2_ = y2;
	    screen_ = new Rectangle(screen.x,screen.y,screen.width,screen.height); 
	    ox_ = x1;
	    oy_ = y1;
	}
    public Rectangle getScreen(){
        return screen_;   
    }
    public double getScale(){
        return scale_;
    }
    public double getOffsetX(){
        return ox_;
    }
    public double getOffsetY(){
        return oy_;
    }
    public JMapPoint getMapTL(){ 
        return new JMapPoint(x1_,y1_);
    }
    public JMapPoint getMapBR(){ 
        return new JMapPoint(x2_,y2_);
    }
    public JMapPoint getPoint(int x, int y){
        return new JMapPoint(0.0,0.0);
	}
	public JMapPoint getPoint(Point p){
	    return getPoint(p.x, p.y);
	}
    public Point getPoint(double x, double y){
        return new Point(0,0);
    }
	public Point getPoint(JMapPoint mp){
	    return getPoint(mp.x,mp.y);
	}
}

