import java.awt.*;
import java.lang.Math;
import JMapTransformBase;

class JMapTransformMercator extends JMapTransformBase
{
    final double PI = 3.1415927;
    double yscale_;
    JMapTransformMercator(Rectangle screen, double x1, double y1, double x2, double y2){
        super(screen,x1,y1,x2,y2);
    	centerMap_ = x1-(x1-x2)/2.0;
    	centerScreen_ = (double)screen.width/2.0;
    	double sx = (double)screen.width/(0.67*(x1-x2));
    	double sy = (double)screen.height/(y1-y2);
    	if(sx<sy)scale_ = sx;
    	else scale_ = sy;
    	screen_ = screen;
    	yscale_ = sy;
    }
    public JMapPoint getPoint(int x, int y){

       	latScale_ = Math.cos(((oy_-(double)y/scale_)/180.0)*PI);
    	return new JMapPoint(
    	    centerMap_-(x-centerScreen_)/(latScale_*scale_),
    	    (oy_-((double)y/scale_)));
	}
    public Point getPoint(double x, double y){
       	latScale_ = Math.cos((y/180.0)*PI);
        return new Point((int)((centerMap_-x)*latScale_*scale_+centerScreen_),
                         (int)((oy_-y)*scale_));
    }
	
     
}

