import java.util.*;
import java.lang.*;

class JTokenParser {

     static public Vector parseIntegerVec(StringTokenizer sts){

        String str = sts.nextToken();
        String strVal;
        Integer intVal;
        StringTokenizer tokenizer;
        Vector v;

        while(!str.endsWith(">")){
            if(str.equals("*")){
                v = new Vector();
                v.addElement(new Integer(-1));
                return v;
            }
            str = str+" "+sts.nextToken();
            if(Character.isLetter(str.charAt(str.length()-1)))
                return null;
        }

        tokenizer = new StringTokenizer(str,"<> ,\t\n\r");
        v = new Vector();

        while(tokenizer.hasMoreTokens()){
            strVal = tokenizer.nextToken();
            try {
                intVal = new Integer(strVal);
                v.addElement(intVal);
            }
            catch(NumberFormatException e){
                break;
            }
        }
        return v;
    }
    static public Vector parseDoubleVec(StringTokenizer sts){
        String str = sts.nextToken();
        String strVal;
        Double dVal;
        StringTokenizer tokenizer;
        Vector v;

        while(!str.endsWith(">")){
            if(str.equals("*")){
                v = new Vector();
                v.addElement(new Double(-1.0));
                return v;
            }
            str = str+" "+sts.nextToken();
            if(Character.isLetter(str.charAt(str.length()-1)))
                return null;
        }

        tokenizer = new StringTokenizer(str,"<> ,\t\n\r");
        v = new Vector();

        while(tokenizer.hasMoreTokens()){
            strVal = tokenizer.nextToken();
            try {
                dVal = new Double(strVal);
                v.addElement(dVal);
            }
            catch(NumberFormatException e){
                break;
            }
        }
        return v;
    }

    static public String parseQuoteString(StringTokenizer sts){
        String str = sts.nextToken();
        String strVal;
        StringTokenizer tokenizer;
        Vector v;

        while(!str.endsWith("\"")){
            str = str+" "+sts.nextToken();
        }

        tokenizer = new StringTokenizer(str,"\"");
        strVal = tokenizer.nextToken();
        return new String(strVal);
    }
}